/****** Object:  StoredProcedure [dbo].[usp_Update_Discharge_Intent]    Script Date: 03/22/2012 11:04:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Update_Discharge_Intent]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Update_Discharge_Intent]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		PII
-- Create date: 24.10.2012
-- Description:	Update discharge intent.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Update_Discharge_Intent] 
	@ID INT,
	@DOMAIN_ID VARCHAR(50),
	@PATIENT_UID UNIQUEIDENTIFIER,
	@DATE_ENTERED DATETIME,
	@IS_ACTIVE BIT,
	@APPOINTMENT_DATE DATETIME,
	@VISTA_SITE_UID UNIQUEIDENTIFIER,	
	@HOSPITAL_LOCATION_UID UNIQUEIDENTIFIER,
	@WARD_UID UNIQUEIDENTIFIER,
	@STATUS NVARCHAR(MAX)
AS
SET NOCOUNT ON

BEGIN

	UPDATE DISCHARGE_INT
		SET
			DOMAIN_ID = @DOMAIN_ID,
			PATIENT_UID =  @PATIENT_UID,
			DATE_ENTERED = @DATE_ENTERED,
			IS_ACTIVE = @IS_ACTIVE,
			APPOINTMENT_DATE = @APPOINTMENT_DATE,
			VISTA_SITE_UID = @VISTA_SITE_UID,
			HOSPITAL_LOCATION_UID = @HOSPITAL_LOCATION_UID,
			WARD_UID = @WARD_UID,
			STATUS = @STATUS
		WHERE ID = @ID

	IF @@ERROR<>0 RETURN
	
END
GO
